--========================================================--
-- Unseasonal Weather - Radio Forecast Messages (Shared)
-- Message pools built from translation keys.
--========================================================--

if not UW_RF then UW_RF = {} end

local OFFSET_BY_ACCURACY = {
    NORMAL      = 6,
    ERRONEOUS   = 4,
    FALSE       = 8,
    INTERRUPTED = ZombRand(1,3), -- 1 a 2 horas
}

UW_RF.MessageKeys = {
    NORMAL = {
        "UW.Radio.Forecast.Normal.01",
        "UW.Radio.Forecast.Normal.02",
        "UW.Radio.Forecast.Normal.03",
        "UW.Radio.Forecast.Normal.04",
        "UW.Radio.Forecast.Normal.05",
        "UW.Radio.Forecast.Normal.06",
        "UW.Radio.Forecast.Normal.07",
        "UW.Radio.Forecast.Normal.08",
        "UW.Radio.Forecast.Normal.09",
        "UW.Radio.Forecast.Normal.10",
        "UW.Radio.Forecast.Normal.11",
        "UW.Radio.Forecast.Normal.12",
        "UW.Radio.Forecast.Normal.13",
        "UW.Radio.Forecast.Normal.14",
        "UW.Radio.Forecast.Normal.15",
        "UW.Radio.Forecast.Normal.16",
        "UW.Radio.Forecast.Normal.17",
        "UW.Radio.Forecast.Normal.18",
        "UW.Radio.Forecast.Normal.19",
        "UW.Radio.Forecast.Normal.20",
        "UW.Radio.Forecast.Normal.21",
        "UW.Radio.Forecast.Normal.22",
        "UW.Radio.Forecast.Normal.23",
        "UW.Radio.Forecast.Normal.24",
        "UW.Radio.Forecast.Normal.25",
        "UW.Radio.Forecast.Normal.26",
        "UW.Radio.Forecast.Normal.27",
        "UW.Radio.Forecast.Normal.28",
        "UW.Radio.Forecast.Normal.29",
        "UW.Radio.Forecast.Normal.30",
        "UW.Radio.Forecast.Normal.31",
        "UW.Radio.Forecast.Normal.32",
        "UW.Radio.Forecast.Normal.33",
        "UW.Radio.Forecast.Normal.34",
        "UW.Radio.Forecast.Normal.35",
        "UW.Radio.Forecast.Normal.36",
        "UW.Radio.Forecast.Normal.37",
        "UW.Radio.Forecast.Normal.38",
        "UW.Radio.Forecast.Normal.39",
        "UW.Radio.Forecast.Normal.40",
    },
    ERRONEOUS = {
        "UW.Radio.Forecast.Alert.01",
        "UW.Radio.Forecast.Alert.02",
        "UW.Radio.Forecast.Alert.03",
        "UW.Radio.Forecast.Alert.04",
        "UW.Radio.Forecast.Alert.05",
        "UW.Radio.Forecast.Alert.06",
        "UW.Radio.Forecast.Alert.07",
        "UW.Radio.Forecast.Alert.08",
        "UW.Radio.Forecast.Alert.09",
        "UW.Radio.Forecast.Alert.10",
        "UW.Radio.Forecast.Alert.11",
        "UW.Radio.Forecast.Alert.12",
        "UW.Radio.Forecast.Alert.13",
        "UW.Radio.Forecast.Alert.14",
        "UW.Radio.Forecast.Alert.15",
        "UW.Radio.Forecast.Alert.16",
        "UW.Radio.Forecast.Alert.17",
        "UW.Radio.Forecast.Alert.18",
        "UW.Radio.Forecast.Alert.19",
        "UW.Radio.Forecast.Alert.20",
    },
    FALSE = {
        "UW.Radio.Forecast.False.01",
        "UW.Radio.Forecast.False.02",
        "UW.Radio.Forecast.False.03",
        "UW.Radio.Forecast.False.04",
        "UW.Radio.Forecast.False.05",
        "UW.Radio.Forecast.False.06",
        "UW.Radio.Forecast.False.07",
        "UW.Radio.Forecast.False.08",
        "UW.Radio.Forecast.False.09",
        "UW.Radio.Forecast.False.10",
    },
    INTERRUPTED = {
        "UW.Radio.Forecast.Interrupt.01",
        "UW.Radio.Forecast.Interrupt.02",
        "UW.Radio.Forecast.Interrupt.03",
        "UW.Radio.Forecast.Interrupt.04",
        "UW.Radio.Forecast.Interrupt.05",
    },
}

------------------------------------------------------------
-- Fallback de traducciones (por si getText falla)
------------------------------------------------------------
UW_RF.FallbackText = UW_RF.FallbackText or {}

local function UW_RF_LoadFallbackFor(langCode, relPath)
    local loaded = 0
    local readersTried = {}

    local function tryReader(rdr)
        if not rdr then return end
        while true do
            local line = rdr:readLine()
            if not line then break end
            line = tostring(line)
            if line:find("=", 1, true) then
                -- Formato LUA: IGUI_ES["KEY"] = "value"
                local k, v = line:match("%[%s*\"(.-)\"%s*%]%s*=%s*\"(.*)\"")
                if not k or not v then
                    -- Formato simple: KEY = texto
                    k, v = line:match("^%s*(.-)%s*=%s*(.*)$")
                    if v then v = v:gsub('^\"', ''):gsub('\"$', '') end
                end
                if k and k ~= "" and v and v ~= "" then
                    UW_RF.FallbackText[k] = v
                    local underscore = k:gsub("%.", "_")
                    if underscore ~= k then
                        UW_RF.FallbackText[underscore] = v
                        UW_RF.FallbackText["IGUI_" .. underscore] = v
                    end
                    loaded = loaded + 1
                end
            end
        end
        rdr:close()
    end

    -- Solo probar la ruta estándar bajo media/lua/shared/Translate
    if getModFileReader then
        local modIds = { "UnseasonalWeather", "Unseasonal Weather" }
        for _, modId in ipairs(modIds) do
            local rdr = getModFileReader(modId, relPath, false)
            table.insert(readersTried, string.format("mod=%s path=%s rdr=%s", modId, relPath, tostring(rdr ~= nil)))
            if rdr then
                tryReader(rdr)
                break
            end
        end
    end

    if loaded == 0 and getDebug and getDebug() then
        print(string.format("[UW_RF] WARN: No fallback lines loaded for %s (%s) Tried: %s", tostring(langCode), tostring(relPath), table.concat(readersTried, " | ")))
    elseif getDebug and getDebug() then
        print(string.format("[UW_RF][DEBUG] Fallback loaded %d lines for %s", loaded, tostring(langCode)))
    end
end

-- Cargamos ES y EN como respaldo
UW_RF_LoadFallbackFor("ES", "media/lua/shared/Translate/ES/IG_UI_ES.txt")
UW_RF_LoadFallbackFor("EN", "media/lua/shared/Translate/EN/IG_UI_EN.txt")

local function UW_RF_getLocalizedText(key)
    if not key or key == "" then return nil end

    local txt = nil
    local candidates = {
        key,
        "IGUI_" .. key,
        key:gsub("%.", "_"),
        "IGUI_" .. key:gsub("%.", "_"),
    }

    for _, cand in ipairs(candidates) do
        if getRadioText then
            txt = getRadioText(cand)
        end
        if (not txt or txt == "" or txt == cand) and getText then
            txt = getText(cand)
        end
        if txt and txt ~= "" and txt ~= cand then
            return txt
        end
        if UW_RF.FallbackText[cand] then
            return UW_RF.FallbackText[cand]
        end
    end
    if (not txt or txt == "" or txt == key) and getDebug and getDebug() then
        print("[UW_RF] WARN: No localized text for key " .. tostring(key))
    end
    return txt
end

local function UW_RF_NewLine(text)
    if not text or text == "" then return nil end
    if not RadioLine or not RadioLine.new then
        if getDebug and getDebug() then
            print("[UW_RF] WARN: RadioLine API unavailable, cannot build line for text: " .. tostring(text))
        end
        return nil
    end
    return RadioLine.new(text, 150, 150, 150)
end

function UW_RF_GetLinesForKey(key)
    if not key or key == "" then return nil end
    local text = UW_RF_getLocalizedText(key) or key
    if getDebug and getDebug() then
        print(string.format("[UW_RF][DEBUG] key=%s text=%s", tostring(key), tostring(text)))
    end
    local line = UW_RF_NewLine(text)
    if not line then
        if getDebug and getDebug() then
            print("[UW_RF] WARN: No line built for key " .. tostring(key))
        end
        return nil
    end
    return { line }
end

UW_RF.Messages = {}

for cat, keys in pairs(UW_RF.MessageKeys) do
    for _, key in ipairs(keys) do
        local messageKey = key
        local accuracy   = cat
        local offset = OFFSET_BY_ACCURACY[accuracy] or 6

        UW_RF.Messages[messageKey] = {
            id = messageKey,
            accuracy = accuracy,
            relatesToEvent = (accuracy == "NORMAL"),
            forecastOffsetHours = offset,
            lines = function()
                return UW_RF_GetLinesForKey(messageKey)
            end
        }
    end
end

function UW_RF_GetLinesById(id)
    if not id then return nil end
    local msg = UW_RF.Messages[id]
    if not msg or not msg.lines then return nil end
    return msg.lines()
end
